 {block name="content"}

<head>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <style>
        /*
    * CONFIRM PAYMENT
    */
        
        #pw_body_form {
            background: url("{$paymentBackground}");
            background-size: cover;
            background-repeat: no-repeat;
            width: 100%;
            height: 1000px;
            margin: 0;
            padding: 0 0 0 0;
            font-family: "Open Sans", helvetica, arial, sans-serif;
        }
        
        #pw_body_form.pw_screen_full p {
            font-size: 15px;
        }
        
        .pw_screen_full .header-menu {
            height: 100px;
        }
        
        .header-menu {
            background-color: #fff;
            box-shadow: rgb(0 0 0 / 39%) 0px 2px 10px 0px;
            position: fixed;
            z-index: 999;
            width: 100%;
            left: 0;
            top: 0;
            display: flex;
            justify-content: center;
        }
        
        .pw_screen_full .header-menu img {
            width: 170px;
        }
        /*
    * HIDDEN CLASES 
    */
        
        .pw_hidden {
            display: none !important;
            transition: .3s;
        }
        
        .pw_block {
            display: block !important;
            transition: .3s;
        }
        /*
    * CLASES FOR THE MODULE
    */
        
        #paymentsway_form {
            padding-top: 150px;
            margin: 0 auto 0;
        }
        
        #paymentsway_form * {
            padding: 5px 10px;
            margin: 2px 0;
            text-align: left;
        }
        
        .js-additional-information {
            margin-left: 0 !important;
        }
        
        #check_payments {
            display: block;
            margin: 10px;
            width: 20px;
            height: 20px;
            background: white;
            cursor: pointer;
            border: 1px solid black;
        }
        
        #check_payments:checked {
            background: #181814;
        }
        
        .pw-container {
            width: 80%;
            vertical-align: middle;
            margin: 0 auto !important;
        }
        
        .pw-col-md-3 {
            width: 50%;
            text-align: left;
        }
        
        .pw_required-field {
            color: red;
        }
        
        .pw-input:focus {
            color: #212529;
            background-color: #fff;
            border-color: #fe8686 !important;
            outline: 0;
            box-shadow: 0 0 0 0.25rem rgb(193 17 17 / 25%) !important;
        }
        
        .pw_screen_mobile {
            height: auto;
        }
        
        .pw-col-md-3 {
            width: 100%;
            text-align: left;
        }
        
        .pw-input {
            width: 100%;
        }
        
        #submit_payments {
            width: 200px;
            padding: 10px 0;
            margin: 10px 0;
            text-align: center;
            font-weight: 600;
            font-size: 19px;
            cursor: pointer;
            color: #F90F40;
            background-color: #181814;
            transition: .5s;
            border: 2px solid #181814;
        }
        
        #submit_payments:hover {
            transition: .5s;
            transform: scale(1.3);
        }
        /**
         * mobile
        **/
        
        #pw_body_form.pw_screen_mobile {
            height: auto;
        }
        
        .pw_screen_mobile .pw-container {
            display: column;
            justify-content: center;
            margin: 0 10%;
        }
        
        .pw_screen_mobile .header-menu {
            height: 200px;
        }
        
        .pw_screen_mobile .header-menu img {
            width: 370px;
        }
        
        .pw_screen_mobile #paymentsway_form {
            padding-top: 250px;
        }
        
        .pw_screen_mobile #submit_payments {
            width: 400px !important;
            font-size: 39px !important;
            padding: 30px;
            margin: 30px 0 0;
        }
        
        .pw_screen_mobile .pw-container p {
            font-size: 45px;
        }
        
        .pw_screen_mobile .pw-input {
            padding: 30px 30px !important;
            font-size: 45px;
        }
        
        .pw_screen_mobile #check_payments {
            width: 100px;
            height: 100px;
        }
        
        .swal2-popup {
            font-size: 33px;
        }
    </style>
</head>

<section id="pw_body_form" class="pw_screen_full">

    <header class="header-menu">
        <img src="{$paymentLogo}" alt="">
    </header>

    <!--- FORMULARIO ---->
    <form action="https://merchant.paymentsway.co/cartaspago/redirect" method="post" id="paymentsway_form" class="row">
        <!--- ID-MERCHANT ---->
        <input type="hidden" name="merchant_id" value="{$id_merchant}">
        <!--- ID-TERMINAL ---->
        <input type="hidden" name="terminal_id" value="{$id_terminal}">
        <!--- ID-FORM ---->
        <input type="hidden" name="form_id" value="{$id_form}">
        <!--- CURRENCY ---->
        <input type="hidden" id="client_currency" name="currency" value="{$currency_iso}">
        <!--- ORDER-NUMBER ---->
        <input type="hidden" name="order_number" value="{$order_id}">
        <!--- CART-RPICE ---->
        <input type="hidden" name="amount" value="{$cart_price}">
        <!--- ORDER-DESCRIPTION ---->
        <input type="hidden" name="order_description" value="{$descForProduct}">

        <!--- CLIENT-EMAIL ---->
        <div class="pw-container client_email">

            <p class="pw-col-md-3">Email<span class="pw_required-field">*</span></p>

            <input type="email" name="client_email" class="pw-input form-control" placeholder="Email" value="" required>

        </div>

        <!--- PHONENUMBER ---->
        <div class="pw-container">

            <p class="pw-col-md-3">Phone Number<span class="pw_required-field">*</span></p>

            <input type="text" name="client_phone" class="pw-input form-control" placeholder="Phone Number" value="" required>

        </div>

        <!--- FIRST-NAME ---->
        <div class="pw-container">

            <p class="pw-col-md-3">First name<span class="pw_required-field">*</span></p>

            <input type="text" name="client_firstname" class="pw-input form-control" placeholder="First name" value="" required>

        </div>

        <!--- LAST-NAME ---->
        <div class="pw-container">

            <p class="pw-col-md-3">Last Name<span class="pw_required-field">*</span></p>

            <input type="text" name="client_lastname" class="pw-input form-control" placeholder="Last Name" value="" required>

        </div>

        <!--- DOCUMENT-TYPE ---->
        <div class="pw-container">

            <p class="pw-col-md-3">Document Type<span class="pw_required-field">*</span></p>

            <select name="id_doct_select" id="id_doct_select" class="select form-select pw-input" data-placeholder="Document Type">
                  <option value="1">Pasaporte</option>
                  <option value="4">Cédula de ciudadanía</option>
                  <option value="5">Cédula de extranjería</option>
                  <option value="6">NIT</option>
          </select>

        </div>

        <!--- CLIENT-DOCTYPE ---->
        <input type="hidden" name="client_doctype" id="client_doctype" value="" placeholder="Documento">

        <div class="pw-container numDoct">

            <p class="pw-col-md-3">Document Number<span class="pw_required-field">*</span></p>

            <input type="text" name="client_numdoc" class="pw-input form-control" value="" placeholder="Document Number" required>
        </div>

        <!--- ADDITIONAL-DATA ---->

        <input type="hidden" name="aditional_data" class="pw-input form-control" value="" placeholder="Your aditional data">

        <!--- RESPONSE-URL ---->
        <input type="hidden" name="response_url" {$indicator_url}>
        <input type="hidden" name="test" value="0">

        <!--- TERMS-AND-CONDITIONS ---->
        <span class="pw-container" style="display: flex; align-items: center; margin: 0 auto; width: 80%;">
            <input type="checkbox" id="check_payments" onclick="change_values()" class="">
            <p>{l s="Acepto los términos del servicio y los cumpliré incondicionalmente"}</p>
        </span>

        <!--- SUBMIT ---->
        <div class="pw-container">
            <input type="hidden" id="submit_payments" name="submit_payments" class="btn btn primary" style="display: block;" value="PAGAR ">
        </div>

    </form>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // GET THE DIVICE DIMENSIONS
        let pw_body_form = document.getElementById('pw_body_form');


        const validateWidth = () => {

            let pw_screen_width = window.screen.width;

            if (pw_screen_width > 797) {

                pw_body_form.classList.add("pw_screen_full");

                pw_body_form.classList.remove("pw_screen_mobile");

            } else {

                pw_body_form.classList.add("pw_screen_mobile");

                pw_body_form.classList.remove("pw_screen_full");

            }

        }

        window.onload = validateWidth;

        //HIDDEN FORM
        let pw_client_doctype = document.getElementById("client_doctype");

        let pw_submit_payments = document.getElementById("submit_payments");


        const change_values = () => {


            /*validate num doct*/

            let numDoct = document.querySelector(".numDoct input");

            if (numDoct.value.length < 5) {

                let pw_screen_width = window.screen.width;

                if (pw_screen_width > 797) {

                    Swal.fire({
                        icon: 'error',
                        width: 400,
                        title: 'Oops...',
                        text: 'El numero de documento debe ser mayor a 5 digitos!',
                        confirmButtonText: 'Completar',
                    });

                    //GET THE SWALL
                    let pw_swall = document.getElementsByClassName("swal2-popup");

                    console.log(pw_swall);

                } else {

                    Swal.fire({
                        icon: 'error',
                        width: 700,
                        title: 'Oops...',
                        text: 'El numero de documento debe ser mayor a 5 digitos!',
                        confirmButtonText: 'Completar',
                    });

                    //GET THE SWALL
                    let pw_swall = document.getElementsByClassName("swal2-popup");

                    console.log(pw_swall);

                }

                return false;
            }

            //take payments values
            //DOCUMENT TYPE
            var pw_id_doct_select = document.getElementById("id_doct_select").value;

            pw_client_doctype.value = pw_id_doct_select;

            //Get The CheckBox
            var pw_check_payments = document.getElementById("check_payments").checked;

            //CHANGE THE CALSS FOR THE PRESTAHSOP AND PAYMENTS BOTTONS
            if (pw_check_payments === true) {

                pw_submit_payments.type = "submit";

            } else {

                pw_submit_payments.type = "hidden";

            }

        }
    </script>
</section>
{/block}