<?php
/**
* 2007-2022 PrestaShop
*
**
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2022 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_')) {
    exit;
}
class Pwmerchant extends PaymentModule
{
    protected $config_form = false;
    public function __construct()
    {
        $this->name = 'pwmerchant';
        $this->tab = 'payments_gateways';
        $this->version = '1.0.1';
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->author = 'payments solutions sas';
        $this->need_instance = 0;
        $this->controllers = array('validation');
        $this->is_eu_compatible = 1;
        $this->currencies = true;
        $this->currencies_mode = 'checkbox';
        /**
         * Set $this->bootstrap to true if your module is compliant with bootstrap (PrestaShop 1.6)
         */
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('Payments Way Merchant');
        $this->description = $this->l('Pasarela de pagos segura');
        $this->confirmUninstall = $this->l('Esta seguro de desinstalar');
    }
    public function install()
    {
        if (extension_loaded('curl') == false)
        {
            $this->_errors[] = $this->l('You have to enable the cURL extension on your server to install this module');
            return false;
        }
        include(dirname(__FILE__).'/sql/install.php');
        return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('backOfficeHeader') &&
            $this->registerHook('payment') &&
            $this->registerHook('paymentReturn') &&
            $this->registerHook('paymentOptions') &&
            $this->registerHook('actionOrderStatusPostUpdate') &&
            $this->registerHook('actionPaymentConfirmation') &&
            $this->registerHook('actionValidateOrder') &&
            $this->registerHook('displayPaymentReturn') &&
            Configuration::updateValue('PW_MERCHANT_STATUS_APPROVED', 2) &&
            Configuration::updateValue('PW_MERCHANT_STATUS_REJECTED', 8) &&
            Configuration::updateValue('PW_MERCHANT_STATUS_PENDING', 3);
    }
    public function uninstall()
    {
        include(dirname(__FILE__).'/sql/uninstall.php');
        return parent::uninstall();
    }
    /**
     * Load the configuration form
     */
    public function getContent()
    {
        if (((bool)Tools::isSubmit('submitPwmerchantModule')) == true) {
            $this->postProcess();
        }
        $this->context->smarty->assign('module_dir', $this->_path);
        return $this->renderForm();
    }
    /**
     * Create the form that will be displayed in the configuration of your module.
     */
    protected function renderForm()
    {
        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name; 
        $defaultLang = (int) Configuration::get('PS_LANG_DEFAULT');
        $helper->default_form_language = $defaultLang;
        $helper->allow_employee_form_lang = $defaultLang;
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submit' . $this->name; 
        $helper->toolbar_btn = [
            'save' => [
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
                '&token='.Tools::getAdminTokenLite('AdminModules'),
            ],
            'back' => [
                'href' => AdminController::$currentIndex .'&token=' . Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back to list')
            ],
        ];
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('pwmerchant');
        $query = Db::getInstance()->executeS($sql);
    
        $respcount = count($query);
        $minus = 1;
        $resp = 0;
        if($respcount != 0){
            
            $resp = $query[($respcount - $minus)];
            
        }
        $output = "";
        $helper->fields_value['pwMerchantId'] = $resp['id_merchant'];
        $helper->fields_value['pwTerminalId'] = $resp['id_terminal'];
        $helper->fields_value['pwFormId'] = $resp['id_form'];
        $helper->fields_value['pwApikey'] = $resp['apikey'];
        $helper->fields_value['pwResponse'] = $resp['indicator_url'];
        if(Tools::isSubmit('submit' . $this->name)){
            $pwMerchantId = Tools::getValue('pwMerchantId');  
            $pwTerminalId = Tools::getValue('pwTerminalId');
            $pwFormId = Tools::getValue('pwFormId');
            $pwApikey = Tools::getValue('pwApikey');
            $pwResponse = Tools::getValue('pwResponse');
            if( $pwMerchantId != '' 
                && $pwTerminalId != '' 
                && $pwFormId != '' 
                && $pwApikey != '' 
                && $pwResponse!= ''){
                //SQL
                $db = \Db::getInstance();
                /** @var bool $result */
                $result = $db->insert(
                    'pwmerchant',
                    [
                        [
                            'id_merchant' => $pwMerchantId,
                            'id_terminal' => $pwTerminalId,
                            'id_form' => $pwFormId,
                            'apikey' => $pwApikey,
                            'indicator_url' => $pwResponse,
                        ],
                    ]
                );
                $output .= $this->displayConfirmation($this->trans('Form submited successfully, please reload for view your data'));
            }else{
                $output .= $this->displayError($this->trans('Form has not been   submited successfully'));
            }
        }
        return $helper->generateForm(array($this->getConfigForm())).$output;
    }
    protected function getConfigForm()
    {
        return array(
            'form' => array(
                'legend' => array(
                'title' => $this->trans('Rating setting'),
                'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type'     => 'text',                             // This is a regular <input> tag.
                        'label'    => 'ID MERCHANT',                   // The <label> for this <input> tag.
                        'name'     => 'pwMerchantId',                   // The content of the 'id' attribute of the <input> tag.
                        'value'    => 'pwMerchantId',
                        'size'     => 10,                                // The content of the 'class' attribute of the <input> tag. To set the size of the element, use these: sm, md, lg, xl, or xxl.
                        'required' => true,                               // If set to true, this option must be set.
                        'desc'     => $this->l('Please enter your ID MERCHANT.') // A help text, displayed right next to the <input> tag.
                    ),
                    array(
                        'type'     => 'text',                             // This is a regular <input> tag.
                        'label'    => 'ID TERMINAL',                   // The <label> for this <input> tag.
                        'name'     => 'pwTerminalId',                             // The content of the 'id' attribute of the <input> tag.
                        'value'     => 'pwTerminalId',                             // The content of the 'id' attribute of the <input> tag.
                        'size'     => 10,                                // The content of the 'class' attribute of the <input> tag. To set the size of the element, use these: sm, md, lg, xl, or xxl.
                        'required' => true,                               // If set to true, this option must be set.
                        'desc'     => $this->l('Please enter your ID TERMINAL.') // A help text, displayed right next to the <input> tag.
                    ),            
                    array(
                        'type'     => 'text',                             // This is a regular <input> tag.
                        'label'    => 'ID BOTON DE PAGO',                   // The <label> for this <input> tag.
                        'name'     => 'pwFormId',                             // The content of the 'id' attribute of the <input> tag.
                        'value'     => 'pwFormId',                             // The content of the 'id' attribute of the <input> tag.
                        'size'     => 10,                                // The content of the 'class' attribute of the <input> tag. To set the size of the element, use these: sm, md, lg, xl, or xxl.
                        'required' => true,                               // If set to true, this option must be set.
                        'desc'     => $this->l('Please enter your ID BOTON DE PAGO.') // A help text, displayed right next to the <input> tag.
                    ),              
                    array(
                        'type'     => 'text',                             // This is a regular <input> tag.
                        'label'    => 'APIKEY',                   // The <label> for this <input> tag.
                        'name'     => 'pwApikey',                             // The content of the 'id' attribute of the <input> tag.
                        'value'     => 'pwApikey',                             // The content of the 'id' attribute of the <input> tag.
                        'size'     => 10,                                // The content of the 'class' attribute of the <input> tag. To set the size of the element, use these: sm, md, lg, xl, or xxl.
                        'required' => true,                               // If set to true, this option must be set.
                        'desc'     => $this->l('Please enter your APIKEY.') // A help text, displayed right next to the <input> tag.
                    ),             
                    array(
                        'type'     => 'text',                             // This is a regular <input> tag.
                        'label'    => 'URL RETORNO AL ECOMMERCE',                   // The <label> for this <input> tag.
                        'name'     => 'pwResponse',                             // The content of the 'id' attribute of the <input> tag.
                        'value'     => 'pwResponse',                             // The content of the 'id' attribute of the <input> tag.
                        'size'     => 10,                                // The content of the 'class' attribute of the <input> tag. To set the size of the element, use these: sm, md, lg, xl, or xxl.
                        'required' => true,                               // If set to true, this option must be set.
                        'desc'     => $this->l('Please enter your URL RETORNO AL ECOMMERCE.') // A help text, displayed right next to the <input> tag.
                    ),
                ),
                'submit' => array(
                    'title' => $this->trans('Save'),
                    'class' => 'btn btn-primary pull-right'         
                )
            ),
        );
    }
    protected function getConfigFormValues()
    {
        return array(
            'PW_MERCHANT_ID' => Configuration::get('PW_MERCHANT_ID', true),
            'PW_TERMINAL_ID' => Configuration::get('PW_TERMINAL_ID', true),
            'PW_FOMR_ID' => Configuration::get('PW_FOMR_ID', true),
            'PW_APIKEY' => Configuration::get('PW_APIKEY', true),
            'PW_URL' => Configuration::get('PW_URL', true),
        );
    }

    protected function postProcess()
    {
        $form_values = $this->getConfigFormValues();

        foreach (array_keys($form_values) as $key) {
            Configuration::updateValue($key, Tools::getValue($key));
        }
    }
    public function hookHeader()
    {
        $order = Tools::getValue('pworder');
        // $reference = Tools::getValue('refence');
        $reference = $order;
        if($order != ""){
            $this->pwGetOrder($order, $reference);
        }
        $this->context->controller->addJS($this->_path.'/views/js/front.js');
        $this->context->controller->addCSS($this->_path.'/views/css/front.css');
    }
    public function pwGetOrder($order){
        $sql = new DbQuery();
        $sql->select('apikey');
        $sql->from('pwmerchant');
        $query = Db::getInstance()->executeS($sql);
        $respcount = count($query);
        $resp = $query[$respcount-1]['apikey'];
        $postUrl = 'https://merchant.paymentsway.co/api/external/v1/getbyexternal/'.$order;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $postUrl);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        // curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("x-api-key:" .$resp));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        $response = curl_exec($ch);
        $ref = $order;
        $resp = json_decode($response);     
        curl_close ($ch);
        $this->pwValidateOrder($resp, $ref);
    }
    /**
     * VALIDATE TRANSACTION  
    */
    public function pwValidateOrder($resp, $ref){
        $countResp = (array) $resp;
        $countResp = count($countResp);
        $resp = (array) $resp[$countResp -1];
        $status = (array) $resp['idstatus'];
        $status = $status['nombre'];
        $estadoTxt = 0;
        switch ($status){
            case "Exitosa":
                $estadoTxt = 2;
                break;
            case "Creada":
                $estadoTxt = 3;
                break;
            case "Fallida":
                $estadoTxt = 8;
                break;
        }
        $sql = 'SELECT * FROM '._DB_PREFIX_.'orders  WHERE `reference` LIKE "'.$ref.'"';
		$orderId = Db::getInstance()->getValue($sql);
		if($orderId != false){
			$history = new OrderHistory();
			$history->id_order = (int)$orderId;
			$history->changeIdOrderState( (int)$estadoTxt, (int)($orderId)); 
			$history->add(true); // No send email
			// $history->addWithemail(true); // Send email
            $this->ValidateBackendOrder($ref);
		}
    }
    /**
     * Response To Merchant
     */
    public function ValidateBackendOrder($order){
        $sql = new DbQuery();
        $sql->select('apikey');
        $sql->from('pwmerchant');
        $query = Db::getInstance()->executeS($sql);
        $respcount = count($query);
        $resp = $query[$respcount-1]['apikey'];
        $fields = array('externalorder' => $order, 'state' => true);
        $fields_string = http_build_query($fields);
        $postUrl = 'http://rationalsoftware.ddns.net:3008/api/transactions/ValidarTransaccionesTcWoocommerce';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $postUrl);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        // curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("x-api-key:" .$resp));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string );
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        $response = curl_exec($ch);
        $ref = $order;
        $resp = json_decode($response);     
        curl_close ($ch);
    }
    /**
     * This method is used to render the payment button,
     * Take care if the button should be displayed or not.
     */
    public function hookPayment($params)
    {
        $currency_id = $params['cart']->id_currency;
        $currency = new Currency((int)$currency_id);
        if (in_array($currency->iso_code, $this->limited_currencies) == false)
            return false;
        $this->smarty->assign('module_dir', $this->_path);
        return $this->display(__FILE__, 'views/templates/hook/payment.tpl');
    }
    /**
     * This hook is used to display the order confirmation page.
     */
    public function hookPaymentReturn($params)
    {
        if ($this->active == false)
            return;
        $order = $params['objOrder'];
        if ($order->getCurrentOrderState()->id != Configuration::get('PS_OS_ERROR'))
            $this->smarty->assign('status', 'ok');
        $this->smarty->assign(array(
            'id_order' => $order->id,
            'reference' => $order->reference,
            'params' => $params,
            'total' => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false),
        ));
        return $this->display(__FILE__, 'views/templates/hook/confirmation.tpl');
    }
    /**
     * Return payment options available for PS 1.7+
     *
     * @param array Hook parameters
     *
     * @return array|null
     */
    public function hookPaymentOptions($params)
    {
        if (!$this->active) {
            return;
        }
        if (!$this->checkCurrency($params['cart'])) {
            return;
        }
        $option = new \PrestaShop\PrestaShop\Core\Payment\PaymentOption();
        $option->setCallToActionText($this->l('Payments Way'))
            ->setAction($this->context->link->getModuleLink($this->name, 'validation', array(), true))
            ->setAdditionalInformation($this->context->smarty->fetch('module:pwmerchant/views/templates/front/infos.tpl'))
            ->setLogo(Media::getMediaPath(_PS_MODULE_DIR_.$this->name.'/logo.png'));
        return [
            $option
        ];
    }
    public function checkCurrency($cart)
    {
        $currency_order = new Currency($cart->id_currency);
        $currencies_module = $this->getCurrency($cart->id_currency);
        if (is_array($currencies_module)) {
            foreach ($currencies_module as $currency_module) {
                if ($currency_order->id == $currency_module['id_currency']) {
                    return true;
                }
            }
        }
        return false;
    }
}
