<?php
/**
* 2007-2022 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2022 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
class PwmerchantValidationModuleFrontController extends ModuleFrontController
{
    
    public $template = "module:pwmerchant/views/templates/front/payments_infos.tpl";

    public function initContent()
    {

        parent::initContent();

         /**
         * Admins Data
        */
        $sql = new DbQuery();
        $sql->select('*');
        $sql->from('pwmerchant');
        $query = Db::getInstance()->executeS($sql);
        
        $respcount = count($query);
        
        $resp = $query[$respcount-1];

        /**
         * GET TOTAL ORDER AMOUNT
         **/

        $totalAmount = $this->getTotalPrice($this->context->cart);

        $currency               = $this->context->currency;
        $currency_iso           = $currency->iso_code;
        
        /**
         * Get The Products Description
         **/
        
        $products = $this->context->cart->getProducts(true);

        $productsCount = count($products);

        $descForProduct = "";

        
        for ($i=0; $i < $productsCount; $i++) { 
            $currentDesc = $products[$i]["name"];
            
            $neg = $productsCount -1 ;
            
            if($i < $neg){
                $descForProduct .= $currentDesc.", ";
            } elseif ($i == $neg) {
                $descForProduct .= $currentDesc."...";
            }
        }

        /*
         * SEND DATA
        */

        //ORDER CUSTOMER

        $order = new Order($this->module->currentOrder); // $this->module->currentOrder is generate after validateOrder
        $order_reference = ($order->reference ? $order->reference : 0);

        // //ORDER ID
        // $orderId = $this->context->cart->id;

        $pw_protocol = stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';

        $link = $_SERVER["HTTP_HOST"];

        $paymentLogo = $pw_protocol . $link . "/modules/pwmerchant/payment.svg";
        $paymentBackground = $pw_protocol . $link . "/modules/pwmerchant/fondo-transacciones.png";

        $this->context->smarty->assign([
            'descForProduct' => $descForProduct,
            'id_merchant' => $resp['id_merchant'],
            'id_terminal' => $resp['id_terminal'],            
            'id_form' => $resp['id_form'],                        
            'currency_iso' => $currency_iso,
            'order_id' => $order_reference,
            'paymentLogo' => $paymentLogo,
            'paymentBackground' => $paymentBackground,
            'indicator_url' => 'value='.$resp['indicator_url'],            
            'cart_price' => $totalAmount,            
        ]);

        $this->setTemplate('module:pwmerchant/views/templates/front/payment_infos.tpl');
        
    }
    /**
     * This class should be use by your Instant Payment
     * Notification system to validate the order remotely
    **/
    /**
     * Get The Total Price In The Cart
    */
    public function getTotalPrice($cart){
        $total = (float)$cart->getOrderTotal(true, Cart::BOTH);
        return $total;
    }

    public function postProcess()
    {
        /*
         * If the module is not active anymore, no need to process anything.
         */
        if ($this->module->active == false) {
            die;
        }
        
        
        /**
         * Since it is an example, we choose sample data,
         * You'll have to get the correct values :)
         */
        $cart_id = $this->context->cart->id;
        $customer_id = $this->context->cart->id_customer;
        $amount = $this->getTotalPrice($this->context->cart);
        $order_state_approved   = Configuration::get('PW_MERCHANT_STATUS_APPROVED');
        $order_state_rejected   = Configuration::get('PW_MERCHANT_STATUS_REJECTED');
        $order_state_pending    = Configuration::get('PW_MERCHANT_STATUS_PENDING');

        /*
         * Restore the context from the $cart_id & the $customer_id to process the validation properly.
         */
        Context::getContext()->cart = new Cart((int) $cart_id);
        Context::getContext()->customer = new Customer((int) $customer_id);
        Context::getContext()->currency = new Currency((int) Context::getContext()->cart->id_currency);
        Context::getContext()->language = new Language((int) Context::getContext()->customer->id_lang);

        $secure_key = Context::getContext()->customer->secure_key;

        if ($this->isValidOrder() === true) {
            $payment_status = Configuration::get('PS_OS_PAYMENT');
            $message = null;
        } else {
            $payment_status = Configuration::get('PS_OS_ERROR');

            /**
             * Add a message to explain why the order has not been validated
             */
            $message = $this->module->l('An error occurred while processing payment');
        }

        $module_name = $this->module->displayName;
        $currency_id = (int) Context::getContext()->currency->id;

        return $this->module->validateOrder($cart_id, $order_state_pending, $amount, $module_name, $message, array(), $currency_id, false, $secure_key);
    }

    protected function isValidOrder()
    {
        /*
         * Add your checks right there
         */
        return true;
    }
}
