<?php
/**
 * Plugin Name:       PAYMENTS WAY MERCHANT
 * Plugin URI:        https://merchant.paymentsway.co
 * Description:       Pasarela de pagos segura
 * Version:           1.0.9
 * Requires at least: 5.9.2
 * Requires PHP:      7.2
 * Author:            PAYMENTS WAY SOLUTIONS S.A.S
 * Author URI:        https://paymentsway.co
 * License:           GPLv2
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI:        https://paymentsway.co
 * Text Domain:       pay way
 * Domain Path:       /languages
 */

 ///ENQUEUE SCRIPT FOR LOCAL STORAGE 
defined('ABSPATH') or die ('Unauthorized Access');

// SCRIPTS
//PLUGIN
add_action('plugins_loaded', 'woocommerce_paymentsWay_gateway', 0);
function woocommerce_paymentsWay_gateway(){
    if(!class_exists('WC_Payment_Gateway')) return;
    class WC_PaymentsWay_Merchant extends WC_Payment_Gateway{
        /**
		 * Constructor pasarela
		 * @access public
		 * @return void
		 */
        public function __construct(){
            $this->id                 = 'paymentsway';
            $this->icon               = apply_filters( 'woocommerce_paymentsway_icon', plugins_url( '/admin/img/favicon.png', __FILE__ ) );
            $this->has_fields         = false;
            $this->method_title       = 'PAYMENTS WAY MERCHANT';
            $this->method_description = 'Integracion de la pasarela Payments Way Merchant para Woocommerce';
            $this->init_form_fields();
            $this->init_settings();
            $this->title             = $this->settings['title'];
            $this->id_merchant       = $this->settings['id_merchant'];
            $this->id_terminal       = $this->settings['id_terminal'];
            $this->id_form           = $this->settings['id_form'];
            $this->response_url     = $this->settings['response_url'];
            $this->apikey            = $this->settings['apikey'];
            
            if (version_compare(WOOCOMMERCE_VERSION, '2.0.0', '>=' )) {
                add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( &$this, 'process_admin_options' ) );
            } else {
                add_action( 'woocommerce_update_options_payment_gateways', array( &$this, 'process_admin_options' ) );
            }
            add_action('woocommerce_receipt_paymentsway', array(&$this, 'payments_receipt_page'));
        }
        /**
		 * Creamos los campos para la configuracion de la pasarela payments way
		 * @access public
		 * @return void
		 */
        function init_form_fields(){
            $this->form_fields = array(
                'enabled' => array(
                    'title'   => __('Habilitar/Deshabilitar', 'payments'),
                    'type'    => 'checkbox',
                    'label'   => __('Habilita realizar pagos con la pasarela payments way', 'payments'),
                    'default' => 'no',
                ),
                'title' => array(
                    'title' => __('Título', 'payments'),
                    'type' => 'text',
                    'label' => __('Este titulo vera el usuario en el checkout'),
                    'default' => __('Payments Way', 'payments'),
                    'remember'=> 'yes',
                ),
                'id_merchant' => array(
                    'title' => __('ID Merchant', 'payments'),
                    'type' => 'text',
                    'label' => __('Id merchant de usuario payments', 'payments'),
                    'default' => __('ID Merchant'),
                    'remember'=> 'yes',
                ),
                'id_terminal' => array(
                    'title' => __('ID Terminal', 'payments'),
                    'type' => 'text',
                    'label' => __('Id terminal de usuario payments', 'payments'),
                    'default' => __('ID Terminal'),
                    'remember'=> 'yes',
                ),
                'id_form' => array(
                    'title' => __('ID Botón de pago', 'payments'),
                    'type' => 'text',
                    'label' => __('Id form de usuario payments', 'payments'),
                    'default' => __('ID Form'),
                    'remember'=> 'yes',
                ),
                'apikey' => array(
                    'title' => __('Apikey ', 'payments'),
                    'type' => 'text',
                    'label' => __('Apikey de usuario payments', 'payments'),
                    'default' => __('Apikey'),
                    'remember'=> 'yes',
                ),
                'response_url' => array(
                    'title' => __('URL de retorno al ecommerce', 'payments'),
                    'type' => 'text',
                    'label' => __('URL de retorno al ecommerce', 'payments'),
                    'default' => __('URL de retorno al ecommerce'),
                    'remember' => 'yes',
                ),
            );
        }
        /**
         * Creamos la vista de administrador
		 * @access public
         * @return void
         */
        public function admin_options(){
            echo '<h2>' . __('Payments Way Merchant Gateway', 'payments') . '</h2>';
            echo '<table class="form-table">';
            $this -> generate_settings_html();
            echo '</table>';
        }
        /**
		 * Escucha el evento checkout y genera una pagina con el formulario de pago
		 * Solo compatible con las versiones menores a la 2.1.0 de WC
         * @access public
         * @return void
		 */
        function payments_receipt_page($order){
            echo '<p id="paymentsway_form_text" style="display:none;">'.__('Gracias por realizar su compra, lo invitamos a ingresar en nuestro ecosistema seguro de transacciones, por favor haga clic en pagar para continuar con su pago.', 'payments').'</p>';
            echo $this -> generate_paymentsway_form($order);
        } 
        /**
		 * Generamos un array con los parametros enviados a la pasarela Payments way
         * @access public   
         * @return void
		 */
        public function get_params_payments_post($order_id){
            global $woocommerce;
            $order = new WC_Order( $order_id);
            $currency = get_woocommerce_currency();
            $amount = number_format(($order -> get_total()),2,'.','');
            //encript
            $description = "";
            //get the products
            $products = $order -> get_items();
            foreach($products as $product){
                $description .= $product['name'] . ',';
            }
            if(strlen($description) > 255){
                $description = substr($description, 0 , 240) . ' ...';
            }
            $tax = number_format(($order -> get_total_tax()) ,2 , '.', '' );
            $taxReturnBase = number_format(($amount - $tax), 2, '.', '');
            if ($tax == 0) $taxReturnBase = 0 ;
            $pw_protocol = stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
            $link = $_SERVER["HTTP_HOST"]; 
            $parameters_args = array(
                'merchant_id'       => $this  -> id_merchant,
                'terminal_id'       => $this  -> id_terminal,
                'form_id'           => $this  -> id_form,
                'order_number'      => $order -> id,
                'amount'            => $amount,
                'currency'          => $currency,
                'order_description' => trim($description, ','),
                'client_email'      => $order -> billing_email,
                'client_phone'      => $order -> billing_phone,
                'client_firstname'  => $order -> billing_first_name,
                'client_lastname'   => $order -> billing_last_name,
                'client_doctype'    => $order -> id_doct_select,
                'client_numdoc'     => $order -> id_doct,
                'aditional_data'    => $order -> aditional_data,
                'response_url'      => $this  -> response_url,
            );
            return $parameters_args;
        }

        /**
		 * Generamos el formulario de compra
         * @access public
         * @return void
		 */
        public function generate_paymentsway_form($order_id){
            global $woocommerce;
            $order = new WC_Order( $order_id);
            $parameters_args = $this->get_params_payments_post($order_id);
            $payments_args_array = array();
            foreach ($parameters_args as $key => $value) {
                $payments_args_array[] = $key . '=' . $value;
            }
            $params_post = implode('&',$payments_args_array);
            $payments_args_array = array();
            foreach ($parameters_args as $key => $value) {
                $payments_args_array[] = "<input type='hidden' name='$key' value='$value'/>";
            }

            wp_enqueue_script( 'pw_valid_script' );
            
            return '<input id="0" name="orderNumberP" class="orderNumberP" type="hidden" value="'. $order->id .'">' .'<form action="https://merchant.paymentsway.co/cartaspago/redirect" method="post" id="paymentsway_form">'. implode('',$payments_args_array ) 
                .'<style>
                #submit_payments {
                    width: 200px;
                    padding: 10px 0;
                    margin: 10px 0;
                    text-align: center;
                    font-weight: 600;
                    font-size: 19px;
                    cursor: pointer;
                    color: #F90F40;
                    background-color: #181814;
                    transition: .5s;
                    border: 2px solid #181814;
                }
                #submit_payments:hover {
                    transition: .5s;
                    transform: scale(1.3);
                }
                </style>'.'<input type="submit" id="submit_payments" style="display:none;width: 200px;padding: 10px 0;margin: 10px 0;text-align: center;font-weight: 600;font-size: 19px;cursor: pointer;color: #F90F40;background-color: #181814;transition: .5s;border: 2px solid #181814;" value="' .__('Pagar', 'payments').'" />
                <script>
                    const im_waiting = () => {
                        let im_a_reference_text = document.querySelectorAll("p#paymentsway_form_text");
                        let im_a_reference_text_array = [...im_a_reference_text];
                        let text_array_count = im_a_reference_text_array.length;
                        if (text_array_count = 1) {
                            const p = im_a_reference_text_array[0];
                            p.style.display = "block";
                        } else {
                            const p = im_a_reference_text_array[text_array_count - 1];
                            p.style.display = "block";
                        }
                        let im_a_reference = document.querySelectorAll("form#paymentsway_form #submit_payments");
                        let im_a_reference_array = [...im_a_reference];
                        let ref_array_count = im_a_reference_array.length;
                        if(ref_array_count = 1){
                            const btn = im_a_reference_array[0];
                            btn.style.display = "block";
                        }else{
                            const btn = im_a_reference_array[ref_array_count - 1];
                            btn.style.display = "block";
                        }
                    };
                    window.onload = im_waiting();
                </script>
                </form>';
        }
        /**
		 * Procesa el pago 
         * @access public
         * @return void
		 */
        function process_payment($order_id){
            global $woocommerce;
            $order = new WC_Order($order_id);
            $woocommerce->cart->empty_cart();
            if (version_compare(WOOCOMMERCE_VERSION, '2.0.19', '<=' )) {
                return array('result' => 'success', 'redirect' => add_query_arg('order', 
                    $order->id, add_query_arg('key', $order->order_key, get_permalink(get_option('woocommerce_pay_page_id'))))
                );
            } else {
                $parameters_args = $this->get_params_payments_post($order_id);
                $payments_args_array = array();
                foreach ($parameters_args as $key => $value) {
                    $payments_args_array[] = $key . '=' . $value;
                }
                $params_post = implode('&', $payments_args_array);
                return array(
                    'result' => 'success',
                    'redirect' => $order->get_checkout_payment_url(true)
                );
            }
        }
        /**
         *  Retoma el response url
         */
        function get_response_url(){
			return $this->settings['response_url'];
        }
        /**
         *  Retoma el response url
         */
        public function get_apikey(){
			return $this->settings['apikey'];
        }
    }

    // /AÑADIR ID Type FORMULARIO DE PAGO/
    function pw_id_type_field_checkout($checkout) {
        global $woocommerce;
        woocommerce_form_field( 'id_doct_select', array(
            'type' => 'select',
            'class' => array('my-field-class form-row-wide'),
            'required' => true,
            'label' => ('Tipo de documento'),
            'placeholder' => ('123456781'),
            'options'     => array(
                '1' => __('Pasaporte'),
                '4' => __('Cédula de ciudadanía'),
                '5' => __('Cédula de extranjería'),
                '6' => __('NIT')),
            $checkout->get_value( 'id_doct_select' ),
            'default' => '4',
        )); 
    }
    add_action( 'woocommerce_after_checkout_billing_form', 'pw_id_type_field_checkout' );

    function pw_id_type_field_update_order_meta( $order ) {
        if ( isset($_POST['id_doct_select']) && ! empty($_POST['id_doct_select']) ) {
            $order->update_meta_data( '_id_doct_select', sanitize_text_field( $_POST['id_doct_select'] ) );
            // Update user data
            if( $order->get_user_id() > 0 ) {
                update_user_meta( $order->get_user_id(), 'id_doct_select', true );
            }
        }
    }

    add_action( 'woocommerce_checkout_create_order', 'pw_id_type_field_update_order_meta' );
    function pw_id_type_field_display_admin_order_meta( $order ){
        $value = $order->get_meta( '_id_doct_select' );
        if ( ! empty($value) ) {
            return '<p><strong>'.__('How did You Hear About Us&#63;').':</strong> ' . $value . '</p>';
        }
    }
    add_action( 'woocommerce_admin_order_data_after_billing_address', 'pw_id_type_field_display_admin_order_meta', 10, 1 );

    //
    // AÑADIR ID doct FORMULARIO DE PAGO
    //
    function pw_id_doct_num_field_checkout($checkout) {
        global $woocommerce;
        woocommerce_form_field( 'id_doct', array(
            'type' => 'text',
            'class' => array('my-field-class form-row-wide'),
            'required' => true,
            'label' => ('Numero de documento'),
            'placeholder' => ('Ej: 123456781'),
            $checkout->get_value( 'id_doct' ),
        )); 
    }
    add_action( 'woocommerce_after_checkout_billing_form', 'pw_id_doct_num_field_checkout' );

    //sanitize and update user meta
    function pw_id_doct_num_field_update_order_meta( $order ) {
        if ( isset($_POST['id_doct']) && ! empty($_POST['id_doct']) ) {
            $order->update_meta_data( '_id_doct', sanitize_text_field( $_POST['id_doct'] ) );
            // Update user data
            if( $order->get_user_id() > 0 ) {
                update_user_meta( $order->get_user_id(), 'id_doct', true );
            }
        }
    }

    //display field in final order
    add_action( 'woocommerce_checkout_create_order', 'pw_id_doct_num_field_update_order_meta' );
    function pw_id_doct_num_field_display_admin_order_meta( $order ){
        $value = $order->get_meta( '_id_doct' );
        if ( ! empty($value) ) {
            return '<p><strong>'.__('How did You Hear About Us&#63;').':</strong> ' . $value . '</p>';
        }
    }
    add_action( 'woocommerce_admin_order_data_after_billing_address', 'pw_id_doct_num_field_display_admin_order_meta', 10, 1 );

    //
    // CREATE ADITIONAL DATA FIELD
    //
    function pw_aditional_data_field_checkout($checkout) {
        global $woocommerce;
        woocommerce_form_field( 'aditional_data', array(
            'type' => 'hidden',
            'class' => array('my-field-class form-row-wide'),
            'required' => false,
            'label' => (''),
            'placeholder' => ('Your message'),
            $checkout->get_value( 'aditional_data' ),
        )); 
    }

    //sanitize and update user meta
    add_action( 'woocommerce_after_checkout_billing_form', 'pw_aditional_data_field_checkout' );

    function pw_aditional_data_field_update_order_meta( $order ) {
        if ( isset($_POST['aditional_data']) && ! empty($_POST['aditional_data']) ) {
            $order->update_meta_data( '_aditional_data', sanitize_text_field( $_POST['aditional_data'] ) );
            // Update user data
            if( $order->get_user_id() > 0 ) {
                update_user_meta( $order->get_user_id(), 'aditional_data', true );
            }
        }
    }
    add_action( 'woocommerce_checkout_create_order', 'pw_aditional_data_field_update_order_meta' );
        
    //display field in final order
    function pw_aditional_data_field_display_admin_order_meta( $order ){
        $value = $order->get_meta( '_aditional_data' );

        if ( ! empty($value) ) {
            return '<p><strong>'.__('How did You Hear About Us&#63;').':</strong> ' . $value . '</p>';
        }
    }
    add_action( 'woocommerce_admin_order_data_after_billing_address', 'pw_aditional_data_field_display_admin_order_meta', 10, 1 );
    
    /*
    ** Notificamos a Woocommerce de la existencia de Payments Way 
    */
    function add_paymentsway($methods){
        $methods[] = 'WC_PaymentsWay_Merchant';
        return $methods;
    }
    add_filter('woocommerce_payment_gateways', 'add_paymentsway');
}
/**
* Get Apikey
* @access public
* @return void
*/
function pw_get_apikey(){
    $payments = new WC_PaymentsWay_Merchant;
    $payments_apikey = $payments->get_apikey();   
    return $payments_apikey;
}
/**
** ACTUALIZAR ESTADO DE TRANSACCION
* @access public
* @return void
*/
function Pw_validate_order( $endpoint )
{
    $commerce_page_endpoint = $endpoint;
    $order = new WC_Order( $commerce_page_endpoint);
    $pw_payment_method = $order->get_payment_method();
    if($commerce_page_endpoint !== ""){
        if($pw_payment_method == "paymentsway" || $pw_payment_method == "payments_console" || $pw_payment_method == "paylands"){
            /**
            * CONSULTA ESTADO DE LA TRANSACCION 
            */
            $payments_api_endpoint = 'https://merchant.paymentsway.co/api/external/v1/getbyexternal/' .$commerce_page_endpoint;
            $payments_api_args     = array(
                'method'  => 'GET',
                'headers' => array( 'x-api-key' => pw_get_apikey() )
            );
            $payments_queries      = array(
                'start'   => 1
            );
            $payments_api_endpoint   = add_query_arg( $payments_queries, $payments_api_endpoint );
            $payments_response       = wp_remote_request( $payments_api_endpoint, $payments_api_args );
            $payments_resp_data      = json_decode( wp_remote_retrieve_body( $payments_response ), true );
            if($payments_resp_data[0] !== "Apikey not exist" ){
                $last_state_transaction_payments = $payments_resp_data[0]["idstatus"]["nombre"];
            }
            // $last_state_transaction_payments = "";
            // foreach($payments_resp_data as $pw_key){
            //     if($pw_key === end($payments_resp_data) && $pw_key !== "Apikey not exist" ){
            //         $last_state_transaction_payments = $pw_key["idstatus"]["nombre"];
            //     }
            // }
            /**
            *  VALIDACIONES DE ORDEN
            */
            global $woocommerce;
            if ($last_state_transaction_payments == "Exitosa"){
                $order->update_status('completed', __('Transaccion completada', 'woothemes'));
            }else if ($last_state_transaction_payments == "Creada"| $last_state_transaction_payments == "Pendiente"){
                $order->update_status('pending', __('Transaccion pendiente', 'woothemes'));
            }else if($last_state_transaction_payments == "Fallida" | $last_state_transaction_payments == "Rechazada"){
                $order->update_status('failed', __('Transaccion fallida', 'woothemes'));
            } else{
            }
        }
    }else{}
}
/**
** ACTUALIZAR ESTADO DE TRANSACCION
* @access public
* @return void
*/
function Pw_aprove_order( $endpoint )
{
    $commerce_page_endpoint = $endpoint;
    $order = new WC_Order( $commerce_page_endpoint);
    $pw_payment_method = $order->get_payment_method();
    if($commerce_page_endpoint !== ""){
        if($pw_payment_method == "paymentsway" || $pw_payment_method == "payments_console" || $pw_payment_method == "paylands"){
            /**
            * CONSULTA ESTADO DE LA TRANSACCION 
            */
            $payments_api_endpoint = 'https://merchant.paymentsway.co/api/external/v1/getbyexternal/' .$commerce_page_endpoint;
            $payments_api_args     = array(
                'method'  => 'GET',
                'headers' => array( 'x-api-key' => pw_get_apikey() )
            );
            $payments_queries      = array(
                'start'   => 1
            );
            $payments_api_endpoint   = add_query_arg( $payments_queries, $payments_api_endpoint );
            $payments_response       = wp_remote_request( $payments_api_endpoint, $payments_api_args );
            $payments_resp_data      = json_decode( wp_remote_retrieve_body( $payments_response ), true );
            $last_state_transaction_payments = "";
            foreach($payments_resp_data as $pw_key){
                if($pw_key === end($payments_resp_data) && $pw_key !== "Apikey not exist" ){
                    $last_state_transaction_payments = $pw_key["idstatus"]["nombre"];
                }
            }
            /**
            *  VALIDACIONES DE ORDEN
            */
            global $woocommerce;
            if ($last_state_transaction_payments == "Exitosa"){
                $order->update_status('completed', __('Transaccion completada', 'woothemes'));
            }else if ($last_state_transaction_payments == "Creada"| $last_state_transaction_payments == "Pendiente"){
                $order->update_status('pending', __('Transaccion pendiente', 'woothemes'));
            }else if($last_state_transaction_payments == "Fallida" | $last_state_transaction_payments == "Rechazada"){
                $order->update_status('failed', __('Transaccion fallida', 'woothemes'));
            } else{
            }
        }
    }else{}
}
/**
 * Validar pago
*/
function pw_validate_payment_order(){
    /**
     * CONSUTA A URL ACTUAL
    */
    if(isset($_GET['order'])){
        $commerce_page_endpoint =  $_GET["order"];
        Pw_validate_order($commerce_page_endpoint);
    }
}
add_action('the_post', 'pw_validate_payment_order');
